% ALPHA ENGINE DEFINITION
% Generated 22-Oct-2018 14:22:10

% SUGGESTED CITATION:
% 2013 Ford 1.6L EcoBoost Engine LEV III Fuel - ALPHA Map Package. Version 2018-10. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2013 Ford 1.6L EcoBoost Engine LEV III Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.596; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.bore_mm =  79; 
engine.stroke_mm =  81.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     104.71975511965977	;     157.39379194484866	;     209.43951023931953	;     261.79938779914943	;     387.46309394274112	;     492.18284906240092	;     596.90260418206071	;     626.74773439116382	;     656.59286460026681		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     132.00000000000000	;     200.38999999999999	;     240.00000000000000	;     250.00000000000000	;     244.00000000000000	;     232.00000000000000	;     216.00000000000000	;     185.14285714285714	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     157.17449818798991	;     183.35849135116376	;     287.99472654305259	;     418.89422214961309	;     523.60596224816004	;     656.59286460026681		]; 
engine.naturally_aspirated_torque_Nm = [	     62.986648633276005	;     112.94429205433246	;     116.27381290800022	;     119.89219061688610	;     107.08107060233179	;     105.97224698219810	;     101.11210615913893		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     104.82447487477943	;     157.18435243460931	;     314.05454560385965	;     366.51914291880917	;     471.23889803846896	;     656.59286460026681		]; 
engine.closed_throttle_torque_Nm = [	    -12.662655044298369	;    -12.820000000000000	;    -15.359999999999999	;    -17.329999999999998	;    -12.779999999999999	;    -13.369999999999999	;    -13.648222349242639		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     52.412237437389727	;     104.82447487477945	;     120.53243814272838	;     136.24040141067735	;     157.17449818798991	;     183.35849135116376	;     209.53613801336175	;     235.59691785240994	;     261.81796711054164	;     287.99472654305259	;     314.17845043369613	;     340.44392389401389	;     366.52785715163202	;     392.71756165550983	;     418.89422214961309	;     471.26093017048402	;     523.60596224816004	;     590.09941342421348	;     656.59286460026681		]; 
engine.fuel_map_torque_Nm = [	    -18.196500000000000	;    -14.379666666666665	;     1.3291071428571428	;     11.583749999999998	;     20.697166666666664	;     34.566428571428574	;     44.200000000000003	;     58.180666666666667	;     69.855555555555554	;     80.397142857142853	;     85.685000000000002	;     95.381399999999999	;     104.89690370370371	;     114.41240740740741	;     124.47457326892111	;     134.53673913043480	;     144.80900000000000	;     154.05000000000001	;     166.13954545454544	;     182.83642857142857	;     191.86047310685223	;     200.88451764227585	;     209.81244557070278	;     218.74037349912967	;     228.12018674956482	;     237.50000000000000	;     250.00000000000000	;     262.50000000000000		]; 
engine.fuel_map_gps = [
  0.019382682697002791	  0.090519645329932549	   0.16638432144480728	   0.18800123941506836	   0.20976671915910058	   0.24022223371471865	   0.28447897617569973	   0.33156477778206567	   0.37090661634247912	   0.40477449359940593	   0.43959068949649843	   0.48565931681576413	   0.53650739038224382	   0.57331298313709012	   0.59492961170340741	   0.61073550324767167	   0.64402609605714045	   0.62718362548646978	   0.65908795040102952	   0.72683470746499690	;
  0.020307172541967761	  0.090287125975680643	   0.16372887089753752	   0.18426618329773287	   0.20500400182254958	   0.23266288027326110	   0.27489188621773275	   0.32083815961796236	   0.35841067133984722	   0.38611789301855937	   0.41634688418157328	   0.46781059006942699	   0.53753415532634519	   0.57555534946654363	   0.59660976224916662	   0.61773782970453917	   0.67374184320475439	   0.70910746168768235	   0.78067327179949564	   0.86610006298460351	;
  0.023667809514549016	  0.091049986781635159	   0.14702012579919382	   0.16582270099383922	   0.18559478437250529	   0.21282625871583602	   0.25389027032635475	   0.29984080451155931	   0.34392132718147772	   0.38555679392152009	   0.41359228928772407	   0.45587600585132926	   0.51662749767715022	   0.56784396528243097	   0.60867061291545232	   0.66088230214454480	   0.78322440747022093	    1.0552060587510022	    1.2812558106216132	    1.4379682648551853	;
  0.021693239043430793	   0.10998931479608964	   0.19153775870867845	   0.21894021134469571	   0.24674319293678301	   0.28307231192304427	   0.33199120599641663	   0.38867013637890374	   0.44322478259016995	   0.50147862245804731	   0.55681176253892661	   0.61655101513206301	   0.67693909193591140	   0.73964641982519597	   0.81638533376282896	   0.89525295845836661	    1.0719747526636942	    1.3537651398692605	    1.6081206046491749	    1.8012169935941738	;
  0.018341342164908951	   0.13565516785574425	   0.25310814913021307	   0.28784100894488962	   0.32177872767912180	   0.36588881341412383	   0.42717473178573451	   0.49537532664924594	   0.56281654682649696	   0.63016945345278352	   0.70150935567125894	   0.77983384551278179	   0.86067638632134746	   0.94089628679563542	    1.0296619738621580	    1.1270269669910817	    1.3362829964454819	    1.6384275177775707	    1.8992192267187717	    2.1201547221296329	;
  0.012554138593337224	   0.18297396377120714	   0.35012301244945954	   0.39411381816523100	   0.43790402387409372	   0.49923298036570912	   0.58348624466989429	   0.67293188314573626	   0.76231782156103611	   0.85434277377626566	   0.95038574173013257	    1.0485239309125856	    1.1509909229169053	    1.2571080852474628	    1.3683516785059315	    1.4914351976212532	    1.7482594614026374	    2.0413428736020660	    2.3453814870421179	    2.6057741307416191	;
  0.011018572655578858	   0.21124964787092135	   0.40766290537760358	   0.46153614095578743	   0.51706187387050262	   0.59506926495872647	   0.69569910354601994	   0.79850786458927470	   0.90294795973588460	    1.0121231580299068	    1.1237051250301964	    1.2369568090366025	    1.3552779136429032	    1.4806929516422960	    1.6156233862953604	    1.7547683500102673	    2.0359448296499414	    2.3364726305168517	    2.6683233618499491	    2.9574033582319625	;
  0.016474485709891819	   0.24764894061792486	   0.48225697818315016	   0.55639830700933823	   0.63193941259837483	   0.73443527020162280	   0.85898154451968256	   0.98231281986962360	    1.1066421190091311	    1.2400119836544945	    1.3766313389047458	    1.5131866316382949	    1.6554547532839514	    1.8086741889364979	    1.9772401731358897	    2.1453771167099056	    2.4735215758832125	    2.7958644775976325	    3.1668135856656234	    3.5082728386198978	;
  0.036077239224752450	   0.29051415327346430	   0.56083685757687229	   0.64478703073549426	   0.73013247664053538	   0.84526046377988984	   0.98740921017487182	    1.1293973441539411	    1.2747097904398859	    1.4275048147700029	    1.5808563651449079	    1.7403262619200710	    1.9063964112424834	    2.0790275682618899	    2.2615948191726982	    2.4593361496369113	    2.8551018032301063	    3.1970731698172004	    3.6238936554503867	    4.0435963076758386	;
  0.067332452417125571	   0.34145464689467797	   0.63166440705551874	   0.72369668069476523	   0.81641072047052055	   0.94208226780576587	    1.1024867503770837	    1.2626729457707204	    1.4266818017603706	    1.5945315689855573	    1.7647104240113323	    1.9427176669742563	    2.1293423215668166	    2.3166359513876915	    2.5089111977467669	    2.7170481381801475	    3.1554130690083473	    3.5575645781388037	    4.0696466598999441	    4.6007555639737046	;
  0.086324818793674166	   0.37148872626162888	   0.66660978963579087	   0.76229539785192879	   0.85939522154540748	   0.99087751727227069	    1.1600400499154824	    1.3289400619886631	    1.5018508188815072	    1.6787551718114797	    1.8577812991804468	    2.0433773918409255	    2.2364398695874455	    2.4329686601643594	    2.6342698658024468	    2.8475338056579029	    3.3006681844709198	    3.7376106267857137	    4.3027992106594022	    4.9044338609899949	;
   0.12572201858021123	   0.43468336505599836	   0.74284823162797220	   0.84201062157668616	   0.94332209997499894	    1.0826205607329868	    1.2666299053596801	    1.4507741277144406	    1.6381872935052797	    1.8309617239225817	    2.0269886621347277	    2.2251879990033103	    2.4290188117057552	    2.6414510799353361	    2.8638566419925326	    3.0903873792656467	    3.5651882870485276	    4.0676438969976969	    4.7476393784651663	    5.5051559946497459	;
   0.16777575194871683	   0.50682242161450564	   0.84586572261159765	   0.94372200080466329	    1.0443380189298732	    1.1853398862032589	    1.3761984808613421	    1.5713262771418406	    1.7703593522049574	    1.9788525809868982	    2.1907728400960327	    2.4000669757313373	    2.6179052528363296	    2.8433478250430397	    3.0856586920019056	    3.3324211673382771	    3.8476607186222287	    4.3966495049771606	    5.2201038322660489	    6.1756087827613602	;
   0.20943037077379212	   0.57856512114376868	   0.94434052199822727	    1.0482019982972883	    1.1503707949967641	    1.2966160008697176	    1.4970537384985183	    1.7024513413596261	    1.9099706032969030	    2.1291425823240231	    2.3479013213234472	    2.5691909149607444	    2.8031161571184655	    3.0482382323789645	    3.3024799492983399	    3.5710312766488985	    4.1298600816289914	    4.7341068338651384	    5.7408754987393156	    6.9312470279613843	;
   0.24886103512524410	   0.64690063286002442	    1.0421655898768578	    1.1563846010510761	    1.2687944938821039	    1.4243530566321709	    1.6374519765569129	    1.8599045496186624	    2.0834033636158447	    2.3066537161943188	    2.5288284734865361	    2.7584539809673658	    3.0072230743918813	    3.2707126876572574	    3.5386760460697113	    3.8208980589734782	    4.4234782570603803	    5.1123154090131058	    6.3664219453846806	    7.8243863866298646	;
   0.27931984324362791	   0.70590507605693731	    1.1290711927957475	    1.2560864266489169	    1.3833490342057653	    1.5534289799198924	    1.7834453197698246	    2.0259073368896847	    2.2678620960393845	    2.4995285766000768	    2.7315578471118895	    2.9750736661122898	    3.2388460977517699	    3.5116800614678469	    3.7987450351262013	    4.0979107551950316	    4.7605398053375563	    5.5510828964311365	    7.0987037042611867	    8.8036131221062739	;
   0.29728406402931817	   0.75989495989041644	    1.2163225255989891	    1.3540609398592081	    1.4922385494012145	    1.6780303686390197	    1.9262917644468693	    2.1839285159747424	    2.4376853363706998	    2.6877725756703654	    2.9450109180074033	    3.2193662047902842	    3.5138937859307826	    3.7956360427188107	    4.0966664320925066	    4.4300573783177857	    5.2229849600158085	    6.1457922912773268	    7.9817912959069819	    9.8652953163931478	;
   0.29987918493935006	   0.80499068816304553	    1.2989116638771099	    1.4468186703844650	    1.5952012876052757	    1.7952510042238004	    2.0545594079807574	    2.3197206351010657	    2.5834842164087028	    2.8515490961454883	    3.1317617475211375	    3.4349977352769216	    3.7518115839962096	    4.0611513059362068	    4.3996828764396128	    4.7878571211192478	    5.7674878600778454	    6.9335920703627387	    8.8880208968525114	    10.839297425834957	;
   0.27957920064227704	   0.85680091770320033	    1.4175338778548459	    1.5804047843202500	    1.7423941220605708	    1.9581575832245997	    2.2356374186956689	    2.5176639387201818	    2.7928521555118828	    3.0786910208401217	    3.3775283481501424	    3.7045736373046210	    4.0503969525710524	    4.4143575841584539	    4.8493447930859084	    5.3641373928459490	    6.6445198510024390	    8.1723739598420586	    10.188327468111645	    12.093602596366333	;
   0.19144822562229166	   0.88977262261870438	    1.5859861147956738	    1.7873579750932418	    1.9860953851143182	    2.2440976648639150	    2.5500443197718186	    2.8417035111294275	    3.1490146056052479	    3.4904756047991059	    3.8287122512925933	    4.2206461869164897	    4.6517783896754858	    5.1276162214886076	    5.6647194045493281	    6.2762765540031982	    7.8755495334767547	    9.9858608203025057	    11.916255763783385	    13.613771606387120	;
   0.12434922356094333	   0.88198428032528919	    1.6447173668348498	    1.8737392885514623	    2.1021463236414464	    2.4023689453847634	    2.7559973535284321	    3.0710946782147475	    3.4070837424263241	    3.7794906740005252	    4.1666091868394393	    4.6027125297884801	    5.0766523546589193	    5.5687866602931839	    6.0771857493923003	    6.6460513783665345	    8.2623440481039800	    10.708598226763881	    12.558477263738904	    14.264785966668015	;
  0.049614902529371167	   0.86501747729803469	    1.6870346383688044	    1.9390621226687419	    2.1931442930305542	    2.5366360949708469	    2.9718761861402352	    3.3695827399685561	    3.7591063769665447	    4.1232685295044291	    4.5217666478830987	    4.9725929543219207	    5.4873856413502091	    6.0156252443797644	    6.4571580313430683	    6.9415203649005086	    8.5248233256752570	    11.088288441373985	    13.007227347907362	    14.820581331789224	;
   0.00000000000000000	   0.84332993743885132	    1.7215053255165997	    1.9877359329254591	    2.2547779418430709	    2.6124449080753331	    3.0652481557294093	    3.5364686450462330	    3.9998598177064388	    4.4522851123072442	    4.8387329583336305	    5.2680233891563804	    5.8053315657164184	    6.3499670001989221	    6.7844937934454599	    7.2278981739478754	    8.8134661230073945	    11.038595974716575	    13.266329666892291	    15.272174901129649	;
   0.00000000000000000	   0.81749250353617420	    1.7501402264436241	    2.0279687080127142	    2.3051789954424748	    2.6734743894754378	    3.1355810552964067	    3.6178412551857204	    4.1266670588027603	    4.6483038119895221	    5.0838328095046768	    5.5284044400971535	    6.0662837511117038	    6.6037839223575476	    7.1144455887299021	    7.6459328689980683	    9.0973862174546927	    10.927500877821711	    13.406506101952219	    15.625823957255381	;
   0.00000000000000000	   0.82113066857213779	    1.7753245214891893	    2.0689524144891336	    2.3617292567669961	    2.7503662895019017	    3.2350604525836517	    3.7272944902737768	    4.2559811633535336	    4.7742407247926675	    5.3029379004913846	    5.8257312216303552	    6.3663881716063129	    6.9157720937650371	    7.4765229499022263	    8.0613549111133267	    9.4007977825295725	    10.999738890092056	    13.506713269334044	    15.898292914860503	;
   0.00000000000000000	   0.83025582081658045	    1.7995596481401084	    2.1135639140305518	    2.4274581197410470	    2.8465150069906047	    3.3760702715674085	    3.9182375979054975	    4.4655723910943816	    5.0010682677359517	    5.5508010806010759	    6.1112549898425472	    6.6796382171660760	    7.2542921481879858	    7.8379183528278915	    8.4381389189171205	    9.7177080049954743	    11.206684428747588	    13.615473243348630	    16.089523745523717	;
   0.00000000000000000	   0.84040538869279069	    1.8409644521791231	    2.1840581283089384	    2.5311136852721274	    2.9956217957030682	    3.5814976101305787	    4.1710876432326387	    4.7544287050100005	    5.3322902912022707	    5.9120397521802435	    6.4992092848761702	    7.0945099863876697	    7.6909476232957834	    8.2946954060710851	    8.9042203500023902	    10.162571692769113	    11.588128180740162	    13.807372046705730	    16.248695510343509	;
   0.00000000000000000	   0.85032294919991325	    1.9169520453834381	    2.2622171602211756	    2.6413603544264950	    3.1475956110398529	    3.7811314574956971	    4.4119996624814988	    5.0355369230989995	    5.6581690587251501	    6.2760100624532793	    6.8921193992176306	    7.5096689751187915	    8.1231183927311879	    8.7398221410564982	    9.3582862849767778	    10.618806910563565	    11.999616150759337	    14.035134875283902	    16.362622435346776	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 24670');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000	    20.000000000000000		]; 
engine.idle_speed_radps.table = [	     71.733032256966936	    71.733032256966936	    73.303828583761842		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
